/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.concurrent;

/**
 * Abstraction of a callback, to be invoked by a middleware upon completion
 * of some asynchronously scheduled action.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface Callback {
    /**
     * Called when action completed successfully.
     * @param result the result of an action
     */
    void completed(Object result);
    /**
     * Called when action failed.
     * @param cause the cause of the failure
     */
    void failed(Throwable cause);
}
